
-- 240

CREATE TABLE T_objet_geometrique_gmt 
(gmt_ID INT IDENTITY PRIMARY KEY, gmt_nom VARCHAR(16), gmt_objet GEOMETRY);

INSERT INTO T_objet_geometrique_gmt (gmt_nom, gmt_objet)
VALUES ('pA', geometry::Parse('POINT(3.2 4.7)'));

INSERT INTO T_objet_geometrique_gmt (gmt_nom, gmt_objet)
VALUES ('pB', geometry::Parse('POINT(4.2 5.7 7)'));

INSERT INTO T_objet_geometrique_gmt (gmt_nom, gmt_objet)
VALUES ('pC', geometry::Parse('POINT(5.2 6.7 8 2.5)'));

SELECT gmt_nom, gmt_objet.STX, gmt_objet.STY, gmt_objet.Z,gmt_objet.M
FROM   T_objet_geometrique_gmt;

SELECT *, gmt_objet.STAsText() AS "WKT"
FROM   T_objet_geometrique_gmt;

-- 241

DELETE FROM T_objet_geometrique_gmt ;

INSERT INTO T_objet_geometrique_gmt (gmt_nom, gmt_objet) 
VALUES ('L1', 'LINESTRING(20 55, 100 55, 20 100)');

INSERT INTO T_objet_geometrique_gmt (gmt_nom, gmt_objet)
VALUES ('P1', 'POLYGON((30 60, 30 90, 70 90, 70 90, 78 78, 70 60, 30 60))');

INSERT INTO T_objet_geometrique_gmt (gmt_nom, gmt_objet)
VALUES ('P2', 'POLYGON((18 78, 54 78, 18 60, 18 78))');

INSERT INTO T_objet_geometrique_gmt (gmt_nom, gmt_objet)
VALUES ('CS1', 'CIRCULARSTRING(18 60, 56 52, 78 68)');

INSERT INTO T_objet_geometrique_gmt (gmt_nom, gmt_objet)
VALUES ('CC1', 'COMPOUNDCURVE((70 96, 40 96), 
                 CIRCULARSTRING(40 96, 38 99, 40 102), (40 102, 70 102), 
                 CIRCULARSTRING(70 102, 72 99, 70 96))');

SELECT *, gmt_objet.STAsText() AS "WKT"
FROM   T_objet_geometrique_gmt;

-- 243, GEOGRAPHY

CREATE TABLE T_objet_geographique_gmg 
(gmg_ID INT IDENTITY PRIMARY KEY, gmg_nom VARCHAR(40), gmg_objet GEOGRAPHY);

INSERT INTO T_objet_geographique_gmg 
VALUES ('Maison', geography::STGeomFromText('POINT(1.508026 43.515619)', 4326));

INSERT INTO T_objet_geographique_gmg 
VALUES ('Propriano', geography::STGeomFromText('POINT(8.893622 41.660056)', 4326));

INSERT INTO T_objet_geographique_gmg 
VALUES ('Brest', geography::STGeomFromText('POINT(-4.504423 48.405161)', 4326));

INSERT INTO T_objet_geographique_gmg 
VALUES ('Propriano-Brest', geography::STGeomFromText('LINESTRING(8.893622 41.660056, -4.504423 48.405161)', 4326));

INSERT INTO T_objet_geographique_gmg 
VALUES ('Maison-Propriano-Brest-Maison',
geography::STGeomFromText('POLYGON((1.508026 43.515619, 8.893622 41.660056, -4.504423 48.405161, 1.508026 43.515619))', 4326));

SELECT gmg_nom, gmg_objet.STDimension() AS "Dimension"
FROM   T_objet_geographique_gmg ;

SELECT gmg_objet
FROM   T_objet_geographique_gmg ;

-- 244, distance

SELECT g1.gmg_nom, g2.gmg_nom, g1.gmg_objet.STDistance(g2.gmg_objet)/1000 AS "distance en km"
FROM   T_objet_geographique_gmg g1, T_objet_geographique_gmg g2
WHERE  g1.gmg_nom = 'Propriano'
AND    (g2.gmg_nom = 'Brest' OR g2.gmg_nom = 'Maison');

-- contenir

DECLARE @cahors GEOGRAPHY;
DECLARE @paris GEOGRAPHY;

SET @cahors = geography::STGeomFromText('POINT(1.437564 44.445791)', 4326);
SET @paris  = geography::STGeomFromText('POINT(2.339687 48.857713)', 4326);

SELECT gmg_nom, gmg_objet.STIntersects(@cahors) AS "Cahors", gmg_objet.STIntersects(@paris) AS "Paris", gmg_objet.STArea()/1000*1000 AS "aire en km carr"
FROM   T_objet_geographique_gmg
WHERE  gmg_nom = 'Maison-Propriano-Brest-Maison';

-- contraintes

CREATE TABLE T_commune_cmn
(cmn_id               INT IDENTITY(1, 1) NOT NULL PRIMARY KEY,
 cmn_geo              GEOGRAPHY          NOT NULL, 
 cmn_nom              VARCHAR(50)        NOT NULL);

CREATE TABLE T_voie_voi
(voi_id               INT IDENTITY(1, 1) NOT NULL PRIMARY KEY,
 cmn_id               INT                NOT NULL 
                      FOREIGN KEY REFERENCES T_commune_cmn(cmn_id),
 voi_nom              VARCHAR(50)        NOT NULL,
 voi_nature           CHAR(12)           NULL,
 voi_depart           GEOGRAPHY          NOT NULL,          
 voi_arrivee          GEOGRAPHY          NOT NULL);

CREATE TABLE T_troncon_trc
(trc_id               INT IDENTITY(1, 1) NOT NULL PRIMARY KEY, 
 voi_id_babord        INT                NOT NULL 
                      FOREIGN KEY REFERENCES T_voie_voi(voi_id),
 voi_id_tribord       INT                NOT NULL 
                      FOREIGN KEY REFERENCES T_voie_voi(voi_id),
 trc_geo              GEOGRAPHY          NOT NULL,          
 trc_nature           CHAR(16)           NULL,
 trc_voies_mont       SMALLINT           NOT NULL
                      CHECK(trc_voies_mont BETWEEN 1 AND 6),  
 trc_voies_desc       SMALLINT           NOT NULL
                      CHECK(trc_voies_desc BETWEEN 1 AND 6),  
 trc_vitesse          SMALLINT           NULL
                      CHECK (trc_vitesse > 0));

-- la gographie d'une commune est de dimension 2

ALTER TABLE T_commune_cmn
   ADD CONSTRAINT CK_cmn_geo 
   CHECK (cmn_geo.STDimension() = 2);

-- le type de l'instance gomtrique d'un point de dpart est un POINT

ALTER TABLE T_voie_voi
   ADD CONSTRAINT CK_voi_ptd 
   CHECK (voi_depart.STGeometryType() = 'Point'
          AND voi_arrivee.STGeometryType() = 'Point'); 

-- le type de l'instance gomtrique d'un tronon est une LINESTRING  2 points

ALTER TABLE T_troncon_trc
   ADD CONSTRAINT CK_TRC_GEO 
   CHECK (trc_geo.STGeometryType() = 'LineString' 
          AND trc_geo.STNumPoints() = 2
          AND trc_geo.STLength() > 0);

-- 246, index

CREATE SPATIAL INDEX IX_gmt_geometry
   ON  T_objet_geometrique_gmt(gmt_objet)
   USING GEOMETRY_GRID
   WITH (
    BOUNDING_BOX = (xmin=15, ymin=48, xmax=102, ymax=104),
    GRIDS = (LEVEL_1=LOW, LEVEL_2=LOW, LEVEL_3=MEDIUM, LEVEL_4=HIGH),
    CELLS_PER_OBJECT = 20);

--

CREATE SPATIAL INDEX IX_gmg_geography
   ON T_objet_geographique_gmg(gmg_objet)
   USING GEOGRAPHY_GRID
   WITH (
    GRIDS = (MEDIUM, LOW, MEDIUM, HIGH ),
    CELLS_PER_OBJECT = 64);

DROP TABLE T_objet_geographique_gmg ;
DROP TABLE T_objet_geometrique_gmt;
DROP TABLE T_troncon_trc;
DROP TABLE T_voie_voi;
DROP TABLE T_commune_cmn;